local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

use "`PPP'\results\fd_nmr_cvd.dta"
keep if food=="eggs" & sig_beta_p!="-" & endpoint=="miis_2g"
sort food type n
save "`PPP'\results\SA\fd_nmr_0_0.dta", replace
export excel using "`PPP'\results\SA\0_0.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="c.bmi_calc c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_1_bmi.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_1_bmi.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_1_bmi.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_1_bmi.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_1_bmi.dta", replace
export excel using "`PPP'\results\SA\1_bmi.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="i.ht c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_2_ht.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_2_ht.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_2_ht.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_2_ht.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_2_ht.dta", replace
export excel using "`PPP'\results\SA\2_ht.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="i.diabetes c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_3_diabetes.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_3_diabetes.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_3_diabetes.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_3_diabetes.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_3_diabetes.dta", replace
export excel using "`PPP'\results\SA\3_diabetes.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="i.fam_cvd i.fam_diabetes c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_4_fam.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_4_fam.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_4_fam.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_4_fam.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_4_fam.dta", replace
export excel using "`PPP'\results\SA\4_fam.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use_4251.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_5_4251.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_5_4251.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_5_4251.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_5_4251.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_5_4251.dta", replace
export excel using "`PPP'\results\SA\5_4251.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy_sv c.diet_week_eggs_sv c.diet_week_fish_sv c.diet_week_fresh_fruit_sv c.diet_week_fresh_veg_sv c.diet_week_meat_sv c.diet_week_other_staple_sv c.diet_week_poultry_sv c.diet_week_preserved_veg_sv c.diet_week_rice_sv c.diet_week_soybean_sv c.diet_week_wheat_sv"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_6_sv.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_6_sv.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_6_sv.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_6_sv.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_6_sv.dta", replace
export excel using "`PPP'\results\SA\6_sv.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_7_fasting.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate' if fasting==1, `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_7_fasting.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_7_fasting.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_7_fasting.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_7_fasting.dta", replace
export excel using "`PPP'\results\SA\7_fasting.xlsx", firstrow(variables) replace

clear all
*******************
*******************
*******************

local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

*FOOD_NMR*********************************

local fmt="cformat(%9.5f) pformat(%5.3f) sformat(%8.3f)"
local food="c.diet_week_dairy c.diet_week_eggs c.diet_week_fish c.diet_week_fresh_fruit c.diet_week_fresh_veg c.diet_week_meat c.diet_week_other_staple c.diet_week_poultry c.diet_week_preserved_veg c.diet_week_rice c.diet_week_soybean c.diet_week_wheat"
local food_1="dairy"
local food_2="eggs"
local food_3="fish"
local food_4="fresh_fruit"
local food_5="fresh_veg"
local food_6="meat"
local food_7="other_staple"
local food_8="poultry"
local food_9="preserved_veg"
local food_10="rice"
local food_11="soybean"
local food_12="wheat"
local covariate="c.age i.is_female i.region_code i.highest_education i.household_income i.occupation i.marital_status c.hours_since_last_ate i.tea_year i.smk_5g i.alc_5g c.met i.self_rated_health"
local nmrs="acace ace ala alb apoa1 apob apob_apoa1 bohbut cit crea dha dha_fa estc faw3 faw3_fa faw6 faw6_fa freec glc gln gp hdl_c hdl_d hdl_tg hdl2_c hdl3_c his idl_c idl_c_per idl_ce idl_ce_per idl_fc idl_fc_per idl_l idl_p idl_pl idl_pl_per idl_tg idl_tg_per ile l_hdl_c l_hdl_c_per l_hdl_ce l_hdl_ce_per l_hdl_fc l_hdl_fc_per l_hdl_l l_hdl_p l_hdl_pl l_hdl_pl_per l_hdl_tg l_hdl_tg_per l_ldl_c l_ldl_c_per l_ldl_ce l_ldl_ce_per l_ldl_fc l_ldl_fc_per l_ldl_l l_ldl_p l_ldl_pl l_ldl_pl_per l_ldl_tg l_ldl_tg_per l_vldl_c l_vldl_c_per l_vldl_ce l_vldl_ce_per l_vldl_fc l_vldl_fc_per l_vldl_l l_vldl_p l_vldl_pl l_vldl_pl_per l_vldl_tg l_vldl_tg_per la la_fa lac ldl_c ldl_d ldl_tg leu m_hdl_c m_hdl_c_per m_hdl_ce m_hdl_ce_per m_hdl_fc m_hdl_fc_per m_hdl_l m_hdl_p m_hdl_pl m_hdl_pl_per m_hdl_tg m_hdl_tg_per m_ldl_c m_ldl_c_per m_ldl_ce m_ldl_ce_per m_ldl_fc m_ldl_fc_per m_ldl_l m_ldl_p m_ldl_pl m_ldl_pl_per m_ldl_tg m_ldl_tg_per m_vldl_c m_vldl_c_per m_vldl_ce m_vldl_ce_per m_vldl_fc m_vldl_fc_per m_vldl_l m_vldl_p m_vldl_pl m_vldl_pl_per m_vldl_tg m_vldl_tg_per mufa mufa_fa pc phe pufa pufa_fa remnant_c s_hdl_c s_hdl_c_per s_hdl_ce s_hdl_ce_per s_hdl_fc s_hdl_fc_per s_hdl_l s_hdl_p s_hdl_pl s_hdl_pl_per s_hdl_tg s_hdl_tg_per s_ldl_c s_ldl_c_per s_ldl_ce s_ldl_ce_per s_ldl_fc s_ldl_fc_per s_ldl_l s_ldl_p s_ldl_pl s_ldl_pl_per s_ldl_tg s_ldl_tg_per s_vldl_c s_vldl_c_per s_vldl_ce s_vldl_ce_per s_vldl_fc s_vldl_fc_per s_vldl_l s_vldl_p s_vldl_pl s_vldl_pl_per s_vldl_tg s_vldl_tg_per serum_c serum_tg sfa sfa_fa sm tg_pg totcho totfa totpg tyr unsat val vldl_c vldl_d vldl_tg xl_hdl_c xl_hdl_c_per xl_hdl_ce xl_hdl_ce_per xl_hdl_fc xl_hdl_fc_per xl_hdl_l xl_hdl_p xl_hdl_pl xl_hdl_pl_per xl_hdl_tg xl_hdl_tg_per xl_vldl_c xl_vldl_c_per xl_vldl_ce xl_vldl_ce_per xl_vldl_fc xl_vldl_fc_per xl_vldl_l xl_vldl_p xl_vldl_pl xl_vldl_pl_per xl_vldl_tg xl_vldl_tg_per xs_vldl_c xs_vldl_c_per xs_vldl_ce xs_vldl_ce_per xs_vldl_fc xs_vldl_fc_per xs_vldl_l xs_vldl_p xs_vldl_pl xs_vldl_pl_per xs_vldl_tg xs_vldl_tg_per xxl_vldl_c xxl_vldl_c_per xxl_vldl_ce xxl_vldl_ce_per xxl_vldl_fc xxl_vldl_fc_per xxl_vldl_l xxl_vldl_p xxl_vldl_pl xxl_vldl_pl_per xxl_vldl_tg xxl_vldl_tg_per"

use "`PPP'\use_half.dta"

postfile fd_nmr str20(food nmr) n1 beta beta_lci beta_uci beta_p using "`PPP'\results\SA\fd_nmr_8_half.dta", replace
set more off

foreach nmr of local nmrs {
	regress nmr_`nmr'_log_sd `food' `covariate', `fmt'
	mat A=r(table)
	sum nmr_`nmr'_log_sd
	forvalues j=1/12 {
		post fd_nmr ("`food_`j''") ("`nmr'") (r(N)) (A[1,`j']) (A[5,`j']) (A[6,`j']) (A[4,`j'])
	}
}

postclose fd_nmr

use "`PPP'\results\SA\fd_nmr_8_half.dta"
sort food
gen rank=.
gen FDR_beta_p=.
forvalues i=1/12 {
	local i1=(225*`i')-224
	local i2=225*`i'
	local i3=225*(`i'-1)
	sort beta_p in `i1'/`i2'
	replace rank=_n-`i3' if food=="`food_`i''"
	replace FDR_beta_p=beta_p*225/rank if food=="`food_`i''"
}
drop rank
sort FDR_beta_p
save "`PPP'\results\SA\fd_nmr_8_half.dta", replace

clear all

*FOOD_NMR_merge***************************

use "`PPP'\results\SA\fd_nmr_8_half.dta"
gen sig_beta_p="-" if FDR_beta_p>=0.05
replace sig_beta_p="*" if FDR_beta_p<0.05
replace sig_beta_p="**" if FDR_beta_p<0.01
replace sig_beta_p="***" if FDR_beta_p<0.001
merge m:1 nmr using "D:\Panlang\fd_nmr_cvd\description.dta", nogen
merge m:1 food nmr using "`PPP'\results\SA\fd_nmr_0_0.dta", keepus(sig) nogen
keep if sig!=.
sort food type n
drop sig
save "`PPP'\results\SA\fd_nmr_8_half.dta", replace
export excel using "`PPP'\results\SA\8_half.xlsx", firstrow(variables) replace

clear all
